<?php
/**
 * Perplexity Pro Automated Redemption System - Premium Frontend
 * Version 2.0 - Redesigned
 */

$uuid = $_GET['uuid'] ?? '';
$invalidLink = empty($uuid) || !preg_match('/^[a-f0-9\-]{36}$/i', $uuid);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title>Perplexity Pro Activation</title>
    <link rel="icon" type="image/png" href="favicon.png">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Sora:wght@300;400;500;600;700&family=Space+Mono:wght@400;700&display=swap" rel="stylesheet">
    <style>
        /* ========== CSS Variables ========== */
        :root {
            --bg-deep: #0d1117;
            --bg-card: rgba(22, 27, 34, 0.8);
            --bg-input: rgba(13, 17, 23, 0.9);
            --glass-border: rgba(48, 54, 61, 0.8);
            --glass-border-hover: rgba(56, 189, 248, 0.4);
            --accent-primary: #20b2aa;
            --accent-glow: rgba(32, 178, 170, 0.5);
            --accent-secondary: #06b6d4;
            --text-primary: #f0f6fc;
            --text-muted: rgba(240, 246, 252, 0.7);
            --text-subtle: rgba(240, 246, 252, 0.4);
            --error: #f85149;
            --success: #3fb950;
            --warning: #d29922;
            --font-display: 'Sora', -apple-system, BlinkMacSystemFont, sans-serif;
            --font-mono: 'Space Mono', monospace;
            --radius-sm: 8px;
            --radius-md: 12px;
            --radius-lg: 16px;
            --radius-xl: 24px;
            --shadow-glow: 0 0 60px rgba(32, 178, 170, 0.15);
        }

        /* ========== Reset ========== */
        *, *::before, *::after {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        /* ========== Body ========== */
        body {
            font-family: var(--font-display);
            background: var(--bg-deep);
            color: var(--text-primary);
            min-height: 100vh;
            overflow-x: hidden;
            line-height: 1.6;
        }

        /* ========== Animated Background ========== */
        .bg-gradient {
            position: fixed;
            inset: 0;
            background: 
                radial-gradient(ellipse 80% 50% at 50% -20%, rgba(32, 178, 170, 0.15), transparent),
                radial-gradient(ellipse 60% 40% at 100% 100%, rgba(6, 182, 212, 0.1), transparent),
                radial-gradient(ellipse 40% 30% at 0% 100%, rgba(32, 178, 170, 0.08), transparent);
            pointer-events: none;
            z-index: 0;
        }

        .grid-overlay {
            position: fixed;
            inset: 0;
            background-image: 
                linear-gradient(rgba(240, 246, 252, 0.02) 1px, transparent 1px),
                linear-gradient(90deg, rgba(240, 246, 252, 0.02) 1px, transparent 1px);
            background-size: 50px 50px;
            pointer-events: none;
            z-index: 1;
        }

        /* ========== Main Container ========== */
        .main-wrapper {
            position: relative;
            z-index: 10;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 40px 20px;
        }

        /* ========== Language Modal ========== */
        .modal-backdrop {
            position: fixed;
            inset: 0;
            background: rgba(1, 4, 9, 0.85);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1000;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .modal-backdrop.active {
            opacity: 1;
            visibility: visible;
        }

        .modal-box {
            background: var(--bg-card);
            border: 1px solid var(--glass-border);
            border-radius: var(--radius-xl);
            padding: 40px;
            max-width: 520px;
            width: 90%;
            transform: scale(0.95) translateY(10px);
            transition: all 0.3s cubic-bezier(0.34, 1.56, 0.64, 1);
            box-shadow: var(--shadow-glow);
        }

        .modal-backdrop.active .modal-box {
            transform: scale(1) translateY(0);
        }

        .modal-header {
            text-align: center;
            margin-bottom: 32px;
        }

        .modal-header h2 {
            font-size: 1.5rem;
            font-weight: 600;
            color: var(--text-primary);
        }

        .modal-header p {
            color: var(--text-muted);
            font-size: 0.95rem;
            margin-top: 8px;
        }

        .lang-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 16px;
        }

        .lang-btn {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 12px;
            padding: 24px 16px;
            background: var(--bg-input);
            border: 1px solid var(--glass-border);
            border-radius: var(--radius-lg);
            cursor: pointer;
            transition: all 0.25s ease;
            position: relative;
            overflow: hidden;
        }

        .lang-btn::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary));
            opacity: 0;
            transition: opacity 0.25s;
        }

        .lang-btn:hover {
            border-color: var(--accent-primary);
            transform: translateY(-4px);
            box-shadow: 0 12px 32px rgba(32, 178, 170, 0.2);
        }

        .lang-btn:hover::before {
            opacity: 0.1;
        }

        .lang-btn .flag-img {
            width: 64px;
            height: 42px;
            object-fit: cover;
            border-radius: 6px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            position: relative;
            z-index: 1;
        }

        .lang-btn .lang-code {
            font-family: var(--font-mono);
            font-size: 0.75rem;
            font-weight: 700;
            color: var(--accent-primary);
            letter-spacing: 2px;
            text-transform: uppercase;
            position: relative;
            z-index: 1;
        }

        .lang-btn .lang-name {
            font-size: 1rem;
            font-weight: 500;
            color: var(--text-primary);
            position: relative;
            z-index: 1;
        }

        /* ========== Header ========== */
        .header {
            text-align: center;
            margin-bottom: 32px;
        }

        .logo-container {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 20px;
            position: relative;
        }

        .logo-glow {
            position: absolute;
            width: 120px;
            height: 120px;
            background: var(--accent-primary);
            border-radius: 50%;
            filter: blur(40px);
            opacity: 0.3;
            animation: pulse-glow 3s ease-in-out infinite;
        }

        @keyframes pulse-glow {
            0%, 100% { opacity: 0.2; transform: scale(0.9); }
            50% { opacity: 0.4; transform: scale(1.1); }
        }

        .logo-img {
            width: 72px;
            height: 72px;
            position: relative;
            z-index: 1;
            animation: float 4s ease-in-out infinite;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-8px); }
        }

        .brand-title {
            font-size: clamp(1.75rem, 5vw, 2.25rem);
            font-weight: 700;
            margin-bottom: 12px;
            background: linear-gradient(135deg, #fff 0%, rgba(255,255,255,0.8) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .brand-subtitle {
            display: inline-flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 8px;
        }

        .pro-badge {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 6px 14px;
            background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary));
            border-radius: 100px;
            font-size: 0.8rem;
            font-weight: 600;
            color: var(--bg-deep);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .pro-badge svg {
            width: 14px;
            height: 14px;
        }

        .duration-text {
            font-size: 1rem;
            color: var(--text-muted);
        }

        .warning-note {
            font-size: 0.85rem;
            color: var(--warning);
            opacity: 0.9;
        }

        /* ========== Progress Indicator ========== */
        .progress-bar {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
            margin-bottom: 32px;
        }

        .progress-step {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .step-dot {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: var(--glass-border);
            transition: all 0.3s ease;
        }

        .step-dot.active {
            background: var(--accent-primary);
            box-shadow: 0 0 12px var(--accent-glow);
        }

        .step-dot.completed {
            background: var(--success);
        }

        .step-line {
            width: 40px;
            height: 2px;
            background: var(--glass-border);
            border-radius: 2px;
            transition: all 0.3s ease;
        }

        .step-line.completed {
            background: var(--accent-primary);
        }

        /* ========== Card ========== */
        .card {
            background: var(--bg-card);
            border: 1px solid var(--glass-border);
            border-radius: var(--radius-xl);
            padding: 40px;
            width: 100%;
            max-width: 440px;
            position: relative;
            box-shadow: var(--shadow-glow);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
        }

        .card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 20%;
            right: 20%;
            height: 1px;
            background: linear-gradient(90deg, transparent, var(--accent-primary), transparent);
            opacity: 0.6;
        }

        .card-header {
            text-align: center;
            margin-bottom: 28px;
        }

        .card-title {
            font-size: 1.375rem;
            font-weight: 600;
            margin-bottom: 8px;
        }

        .card-desc {
            color: var(--text-muted);
            font-size: 0.95rem;
        }

        /* ========== Form Elements ========== */
        .form-group {
            margin-bottom: 20px;
        }

        .input-field {
            width: 100%;
            padding: 16px 20px;
            background: var(--bg-input);
            border: 1px solid var(--glass-border);
            border-radius: var(--radius-md);
            color: var(--text-primary);
            font-family: var(--font-display);
            font-size: 1rem;
            outline: none;
            transition: all 0.25s ease;
        }

        .input-field::placeholder {
            color: var(--text-subtle);
        }

        .input-field:focus {
            border-color: var(--accent-primary);
            box-shadow: 0 0 0 3px rgba(32, 178, 170, 0.15);
        }

        /* ========== OTP Inputs ========== */
        .otp-container {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-bottom: 28px;
        }

        .otp-box {
            width: 52px;
            height: 64px;
            background: var(--bg-input);
            border: 2px solid var(--glass-border);
            border-radius: var(--radius-md);
            color: var(--text-primary);
            font-family: var(--font-mono);
            font-size: 1.5rem;
            font-weight: 700;
            text-align: center;
            outline: none;
            transition: all 0.2s ease;
            caret-color: var(--accent-primary);
        }

        .otp-box:focus {
            border-color: var(--accent-primary);
            box-shadow: 0 0 0 3px rgba(32, 178, 170, 0.15);
            transform: scale(1.05);
        }

        .otp-box.filled {
            border-color: var(--accent-primary);
            background: rgba(32, 178, 170, 0.1);
        }

        /* ========== Button ========== */
        .btn {
            width: 100%;
            padding: 16px 28px;
            border: none;
            border-radius: var(--radius-md);
            font-family: var(--font-display);
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.25s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            text-decoration: none;
            position: relative;
            overflow: hidden;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary));
            color: var(--bg-deep);
        }

        .btn-primary:hover:not(:disabled) {
            transform: translateY(-2px);
            box-shadow: 0 12px 28px rgba(32, 178, 170, 0.35);
        }

        .btn-primary:active:not(:disabled) {
            transform: translateY(0);
        }

        .btn:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }

        .btn .spinner {
            width: 20px;
            height: 20px;
            border: 2px solid transparent;
            border-top-color: currentColor;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        /* ========== Messages ========== */
        .message {
            margin-top: 16px;
            padding: 14px 18px;
            border-radius: var(--radius-md);
            font-size: 0.9rem;
            display: none;
            animation: slide-in 0.3s ease;
        }

        .message.show {
            display: block;
        }

        .message.error {
            background: rgba(248, 81, 73, 0.1);
            border: 1px solid rgba(248, 81, 73, 0.3);
            color: var(--error);
        }

        .message.success {
            background: rgba(63, 185, 80, 0.1);
            border: 1px solid rgba(63, 185, 80, 0.3);
            color: var(--success);
        }

        .message.info {
            background: rgba(32, 178, 170, 0.1);
            border: 1px solid rgba(32, 178, 170, 0.3);
            color: var(--accent-primary);
        }

        @keyframes slide-in {
            from { opacity: 0; transform: translateY(-8px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* ========== Success State ========== */
        .success-visual {
            text-align: center;
            margin-bottom: 28px;
        }

        .success-icon {
            width: 100px;
            height: 100px;
            margin: 0 auto;
            position: relative;
        }

        .success-circle {
            width: 100%;
            height: 100%;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--success), #22c55e);
            display: flex;
            align-items: center;
            justify-content: center;
            animation: pop-in 0.5s cubic-bezier(0.34, 1.56, 0.64, 1);
            position: relative;
        }

        .success-circle::before {
            content: '';
            position: absolute;
            inset: -10px;
            border-radius: 50%;
            background: var(--success);
            filter: blur(25px);
            opacity: 0.4;
            z-index: -1;
        }

        @keyframes pop-in {
            0% { transform: scale(0); }
            70% { transform: scale(1.1); }
            100% { transform: scale(1); }
        }

        .success-check {
            width: 48px;
            height: 48px;
            stroke: var(--bg-deep);
            stroke-width: 3;
            fill: none;
        }

        .success-check path {
            stroke-dasharray: 60;
            stroke-dashoffset: 60;
            animation: draw-check 0.4s ease-out 0.3s forwards;
        }

        @keyframes draw-check {
            to { stroke-dashoffset: 0; }
        }

        /* ========== Footer ========== */
        .footer {
            margin-top: 28px;
            text-align: center;
        }

        .lang-toggle {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 20px;
            background: transparent;
            border: 1px solid var(--glass-border);
            border-radius: 100px;
            color: var(--text-muted);
            font-family: var(--font-display);
            font-size: 0.9rem;
            cursor: pointer;
            transition: all 0.25s;
        }

        .lang-toggle:hover {
            border-color: var(--accent-primary);
            color: var(--accent-primary);
        }

        .lang-toggle .current-flag {
            width: 20px;
            height: 14px;
            object-fit: cover;
            border-radius: 2px;
        }

        /* ========== Loading Overlay ========== */
        .loading-screen {
            position: fixed;
            inset: 0;
            background: rgba(13, 17, 23, 0.95);
            backdrop-filter: blur(8px);
            display: none;
            align-items: center;
            justify-content: center;
            flex-direction: column;
            gap: 24px;
            z-index: 2000;
        }

        .loading-screen.active {
            display: flex;
        }

        .loading-animation {
            width: 64px;
            height: 64px;
            border: 3px solid var(--glass-border);
            border-top-color: var(--accent-primary);
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        .loading-message {
            color: var(--text-muted);
            font-size: 1rem;
            text-align: center;
        }

        /* ========== Step Visibility ========== */
        .step {
            animation: fade-up 0.4s ease;
        }

        .step.hidden {
            display: none;
        }

        @keyframes fade-up {
            from { opacity: 0; transform: translateY(16px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* ========== Error Card ========== */
        .error-card {
            text-align: center;
            border-color: var(--error);
        }

        .error-card::before {
            background: linear-gradient(90deg, transparent, var(--error), transparent);
        }

        .error-card .card-title {
            color: var(--error);
        }

        .error-icon {
            width: 64px;
            height: 64px;
            margin: 0 auto 20px;
            stroke: var(--error);
            stroke-width: 2;
            fill: none;
        }

        /* ========== RTL Support ========== */
        [dir="rtl"] .otp-container {
            direction: ltr;
        }

        [dir="rtl"] .brand-subtitle {
            flex-direction: row-reverse;
        }

        /* ========== Responsive ========== */
        @media (max-width: 520px) {
            .card {
                padding: 32px 24px;
            }

            .modal-box {
                padding: 32px 20px;
            }

            .lang-grid {
                gap: 12px;
            }

            .lang-btn {
                padding: 20px 12px;
            }

            .lang-btn .flag-img {
                width: 52px;
                height: 34px;
            }

            .otp-box {
                width: 44px;
                height: 56px;
                font-size: 1.25rem;
            }

            .otp-container {
                gap: 8px;
            }
        }

        @media (max-width: 380px) {
            .otp-box {
                width: 38px;
                height: 50px;
                font-size: 1.1rem;
            }

            .otp-container {
                gap: 6px;
            }

            .lang-grid {
                grid-template-columns: 1fr;
            }

            .lang-btn {
                flex-direction: row;
                justify-content: flex-start;
                gap: 16px;
                padding: 16px 20px;
            }
        }
    </style>
</head>
<body>
    <!-- Background Effects -->
    <div class="bg-gradient"></div>
    <div class="grid-overlay"></div>

    <!-- Language Modal -->
    <div class="modal-backdrop active" id="langModal">
        <div class="modal-box">
            <div class="modal-header">
                <h2 data-i18n="select-language">Select Language</h2>
                <p data-i18n="select-language-desc">Choose your preferred language</p>
            </div>
            <div class="lang-grid">
                <button class="lang-btn" data-lang="en">
                    <img src="assets/images/flag-en.png" alt="English" class="flag-img">
                    <span class="lang-code">EN</span>
                    <span class="lang-name">English</span>
                </button>
                <button class="lang-btn" data-lang="zh">
                    <img src="assets/images/flag-zh.png" alt="中文" class="flag-img">
                    <span class="lang-code">中文</span>
                    <span class="lang-name">Chinese</span>
                </button>
                <button class="lang-btn" data-lang="ar">
                    <img src="assets/images/flag-ar.png" alt="العربية" class="flag-img">
                    <span class="lang-code">عربي</span>
                    <span class="lang-name">العربية</span>
                </button>
                <button class="lang-btn" data-lang="ku">
                    <img src="assets/images/flag-ku.webp" alt="کوردی" class="flag-img">
                    <span class="lang-code">کوردی</span>
                    <span class="lang-name">Kurdish</span>
                </button>
            </div>
        </div>
    </div>

    <!-- Loading Screen -->
    <div class="loading-screen" id="loadingScreen">
        <div class="loading-animation"></div>
        <p class="loading-message" id="loadingMsg">Activating your Pro subscription...</p>
    </div>

    <!-- Main Content -->
    <div class="main-wrapper">
        <!-- Header -->
        <header class="header">
            <div class="logo-container">
                <div class="logo-glow"></div>
                <img src="assets/images/logo.png" alt="Perplexity" class="logo-img">
            </div>
            <h1 class="brand-title">Perplexity Pro</h1>
            <div class="brand-subtitle">
                <span class="pro-badge">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"/>
                    </svg>
                    PRO
                </span>
                <span class="duration-text" data-i18n="duration">12 Months Subscription</span>
            </div>
            <p class="warning-note" data-i18n="warning">* Valid only for accounts without Pro</p>
        </header>

        <!-- Progress Bar -->
        <div class="progress-bar">
            <div class="step-dot active" id="dot1"></div>
            <div class="step-line" id="line1"></div>
            <div class="step-dot" id="dot2"></div>
            <div class="step-line" id="line2"></div>
            <div class="step-dot" id="dot3"></div>
        </div>

        <!-- Invalid Link -->
        <?php if ($invalidLink): ?>
        <div class="card error-card step" id="invalidStep">
            <svg class="error-icon" viewBox="0 0 24 24">
                <circle cx="12" cy="12" r="10"/>
                <line x1="15" y1="9" x2="9" y2="15"/>
                <line x1="9" y1="9" x2="15" y2="15"/>
            </svg>
            <h2 class="card-title" data-i18n="invalid-link">Invalid Link</h2>
            <p class="card-desc" data-i18n="invalid-link-desc">This redemption link is invalid or has expired. Please check your link and try again.</p>
        </div>
        <?php else: ?>

        <!-- Step 1: Email -->
        <div class="card step" id="step1">
            <div class="card-header">
                <h2 class="card-title" data-i18n="enter-email">Enter Your Email</h2>
                <p class="card-desc" data-i18n="email-desc">Enter the email address for your Perplexity account</p>
            </div>
            
            <form id="emailForm">
                <div class="form-group">
                    <input 
                        type="email" 
                        class="input-field" 
                        id="emailInput"
                        placeholder="your@email.com"
                        data-i18n-placeholder="email-placeholder"
                        required
                        autocomplete="email"
                    >
                </div>
                <button type="submit" class="btn btn-primary" id="sendOtpBtn">
                    <span class="btn-text" data-i18n="send-code">Send Verification Code</span>
                    <span class="spinner" style="display: none;"></span>
                </button>
            </form>
            <div class="message" id="emailMsg"></div>
        </div>

        <!-- Step 2: OTP -->
        <div class="card step hidden" id="step2">
            <div class="card-header">
                <h2 class="card-title" data-i18n="enter-otp">Enter Verification Code</h2>
                <p class="card-desc" data-i18n="otp-desc">Check your email for the 6-digit code</p>
            </div>
            
            <div class="otp-container">
                <input type="text" class="otp-box" maxlength="1" inputmode="numeric" pattern="[0-9]">
                <input type="text" class="otp-box" maxlength="1" inputmode="numeric" pattern="[0-9]">
                <input type="text" class="otp-box" maxlength="1" inputmode="numeric" pattern="[0-9]">
                <input type="text" class="otp-box" maxlength="1" inputmode="numeric" pattern="[0-9]">
                <input type="text" class="otp-box" maxlength="1" inputmode="numeric" pattern="[0-9]">
                <input type="text" class="otp-box" maxlength="1" inputmode="numeric" pattern="[0-9]">
            </div>
            
            <button class="btn btn-primary" id="verifyOtpBtn" disabled>
                <span class="btn-text" data-i18n="verify">Verify & Activate</span>
                <span class="spinner" style="display: none;"></span>
            </button>
            <div class="message" id="otpMsg"></div>
        </div>

        <!-- Step 3: Success -->
        <div class="card step hidden" id="step3">
            <div class="success-visual">
                <div class="success-icon">
                    <div class="success-circle">
                        <svg class="success-check" viewBox="0 0 50 50">
                            <path d="M14 27l7 7 16-16" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                </div>
            </div>
            <div class="card-header">
                <h2 class="card-title" data-i18n="success">Successfully Activated!</h2>
                <p class="card-desc" data-i18n="success-desc">Your 12-month Perplexity Pro subscription is now active. Enjoy unlimited access!</p>
            </div>
            <a href="https://www.perplexity.ai" class="btn btn-primary" target="_blank">
                <span class="btn-text" data-i18n="go-perplexity">Go to Perplexity</span>
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M7 17L17 7M17 7H7M17 7V17"/>
                </svg>
            </a>
        </div>

        <?php endif; ?>

        <!-- Footer -->
        <footer class="footer">
            <button class="lang-toggle" id="langToggle">
                <img src="assets/images/flag-en.png" alt="" class="current-flag" id="currentFlag">
                <span id="currentLangName">English</span>
                <svg width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <polyline points="6 9 12 15 18 9"/>
                </svg>
            </button>
        </footer>
    </div>

    <!-- Hidden Data -->
    <input type="hidden" id="uuidData" value="<?php echo htmlspecialchars($uuid); ?>">
    <input type="hidden" id="sessionData" value="">

    <script>
        // ========== Translations ==========
        const i18n = {
            en: {
                'select-language': 'Select Language',
                'select-language-desc': 'Choose your preferred language',
                'duration': '12 Months Subscription',
                'warning': '* Valid only for accounts without Pro',
                'invalid-link': 'Invalid Link',
                'invalid-link-desc': 'This redemption link is invalid or has expired. Please check your link and try again.',
                'enter-email': 'Enter Your Email',
                'email-desc': 'Enter the email address for your Perplexity account',
                'email-placeholder': 'your@email.com',
                'send-code': 'Send Verification Code',
                'enter-otp': 'Enter Verification Code',
                'otp-desc': 'Check your email for the 6-digit code',
                'verify': 'Verify & Activate',
                'success': 'Successfully Activated!',
                'success-desc': 'Your 12-month Perplexity Pro subscription is now active. Enjoy unlimited access!',
                'go-perplexity': 'Go to Perplexity',
                'activating': 'Activating your Pro subscription...',
                'sending': 'Sending verification code...',
                'verifying': 'Verifying code...'
            },
            zh: {
                'select-language': '选择语言',
                'select-language-desc': '选择您的首选语言',
                'duration': '12个月订阅',
                'warning': '* 仅适用于没有Pro的账户',
                'invalid-link': '链接无效',
                'invalid-link-desc': '此兑换链接无效或已过期。请检查您的链接后重试。',
                'enter-email': '输入您的邮箱',
                'email-desc': '输入您的Perplexity账户邮箱地址',
                'email-placeholder': '您的邮箱@email.com',
                'send-code': '发送验证码',
                'enter-otp': '输入验证码',
                'otp-desc': '请查看邮箱中的6位数字验证码',
                'verify': '验证并激活',
                'success': '激活成功！',
                'success-desc': '您的12个月Perplexity Pro订阅已激活。尽情享受无限访问！',
                'go-perplexity': '前往Perplexity',
                'activating': '正在激活您的Pro订阅...',
                'sending': '正在发送验证码...',
                'verifying': '正在验证...'
            },
            ar: {
                'select-language': 'اختر اللغة',
                'select-language-desc': 'اختر لغتك المفضلة',
                'duration': 'اشتراك 12 شهر',
                'warning': '* صالح فقط للحسابات بدون Pro',
                'invalid-link': 'رابط غير صالح',
                'invalid-link-desc': 'هذا الرابط غير صالح أو منتهي الصلاحية. يرجى التحقق من الرابط والمحاولة مرة أخرى.',
                'enter-email': 'أدخل بريدك الإلكتروني',
                'email-desc': 'أدخل البريد الإلكتروني لحساب Perplexity الخاص بك',
                'email-placeholder': 'بريدك@email.com',
                'send-code': 'إرسال رمز التحقق',
                'enter-otp': 'أدخل رمز التحقق',
                'otp-desc': 'تحقق من بريدك للحصول على الرمز المكون من 6 أرقام',
                'verify': 'تحقق وفعّل',
                'success': 'تم التفعيل بنجاح!',
                'success-desc': 'تم تفعيل اشتراك Perplexity Pro لمدة 12 شهرًا. استمتع بالوصول غير المحدود!',
                'go-perplexity': 'انتقل إلى Perplexity',
                'activating': 'جاري تفعيل اشتراكك Pro...',
                'sending': 'جاري إرسال رمز التحقق...',
                'verifying': 'جاري التحقق...'
            },
            ku: {
                'select-language': 'زمان هەڵبژێرە',
                'select-language-desc': 'زمانی دڵخوازت هەڵبژێرە',
                'duration': 'بەشداریکردنی ١٢ مانگ',
                'warning': '* تەنها بۆ ئەکاونتەکانی بێ Pro',
                'invalid-link': 'لینکی نادروست',
                'invalid-link-desc': 'ئەم لینکە نادروستە یان بەسەرچووە. تکایە لینکەکەت بپشکنە و دووبارە هەوڵبدەرەوە.',
                'enter-email': 'ئیمەیڵەکەت بنووسە',
                'email-desc': 'ئیمەیڵی ئەکاونتی Perplexity ـەکەت بنووسە',
                'email-placeholder': 'ئیمەیڵەکەت@email.com',
                'send-code': 'کۆدی پشتڕاستکردنەوە بنێرە',
                'enter-otp': 'کۆدی پشتڕاستکردنەوە بنووسە',
                'otp-desc': 'ئیمەیڵەکەت بپشکنە بۆ کۆدی ٦ ژمارەیی',
                'verify': 'پشتڕاستکردنەوە و چالاککردن',
                'success': 'بە سەرکەوتوویی چالاک کرا!',
                'success-desc': 'بەشداریکردنی ١٢ مانگەی Perplexity Pro چالاک کرا. چێژ لە دەستڕاگەیشتنی بێسنور وەربگرە!',
                'go-perplexity': 'بڕۆ بۆ Perplexity',
                'activating': 'چالاککردنی بەشداریکردنی Pro...',
                'sending': 'ناردنی کۆدی پشتڕاستکردنەوە...',
                'verifying': 'پشتڕاستکردنەوە...'
            }
        };

        const langMeta = {
            en: { name: 'English', flag: 'assets/images/flag-en.png', dir: 'ltr' },
            zh: { name: '中文', flag: 'assets/images/flag-zh.png', dir: 'ltr' },
            ar: { name: 'العربية', flag: 'assets/images/flag-ar.png', dir: 'rtl' },
            ku: { name: 'کوردی', flag: 'assets/images/flag-ku.webp', dir: 'rtl' }
        };

        let currentLang = 'en';

        // ========== DOM Elements ==========
        const $ = id => document.getElementById(id);
        const $$ = sel => document.querySelectorAll(sel);

        const langModal = $('langModal');
        const loadingScreen = $('loadingScreen');
        const loadingMsg = $('loadingMsg');
        const step1 = $('step1');
        const step2 = $('step2');
        const step3 = $('step3');
        const emailForm = $('emailForm');
        const emailInput = $('emailInput');
        const sendOtpBtn = $('sendOtpBtn');
        const verifyOtpBtn = $('verifyOtpBtn');
        const otpBoxes = $$('.otp-box');
        const emailMsg = $('emailMsg');
        const otpMsg = $('otpMsg');
        const langToggle = $('langToggle');
        const currentFlag = $('currentFlag');
        const currentLangName = $('currentLangName');

        // Progress elements
        const dot1 = $('dot1');
        const dot2 = $('dot2');
        const dot3 = $('dot3');
        const line1 = $('line1');
        const line2 = $('line2');

        // ========== Language Functions ==========
        function setLanguage(lang) {
            currentLang = lang;
            const meta = langMeta[lang];
            
            document.documentElement.lang = lang;
            document.documentElement.dir = meta.dir;
            
            $$('[data-i18n]').forEach(el => {
                const key = el.dataset.i18n;
                if (i18n[lang][key]) el.textContent = i18n[lang][key];
            });

            $$('[data-i18n-placeholder]').forEach(el => {
                const key = el.dataset.i18nPlaceholder;
                if (i18n[lang][key]) el.placeholder = i18n[lang][key];
            });

            currentFlag.src = meta.flag;
            currentLangName.textContent = meta.name;
            
            localStorage.setItem('perplexity-lang', lang);
        }

        // ========== Step Navigation ==========
        function goToStep(step) {
            step1?.classList.add('hidden');
            step2?.classList.add('hidden');
            step3?.classList.add('hidden');

            // Reset progress
            [dot1, dot2, dot3].forEach(d => d?.classList.remove('active', 'completed'));
            [line1, line2].forEach(l => l?.classList.remove('completed'));

            if (step >= 1) dot1?.classList.add(step === 1 ? 'active' : 'completed');
            if (step >= 2) {
                dot2?.classList.add(step === 2 ? 'active' : 'completed');
                line1?.classList.add('completed');
            }
            if (step >= 3) {
                dot3?.classList.add('active');
                line2?.classList.add('completed');
            }

            if (step === 1) step1?.classList.remove('hidden');
            if (step === 2) step2?.classList.remove('hidden');
            if (step === 3) step3?.classList.remove('hidden');
        }

        // ========== UI Helpers ==========
        function setButtonLoading(btn, loading) {
            const text = btn.querySelector('.btn-text');
            const spinner = btn.querySelector('.spinner');
            btn.disabled = loading;
            if (text) text.style.opacity = loading ? '0.6' : '1';
            if (spinner) spinner.style.display = loading ? 'block' : 'none';
        }

        function showMessage(el, text, type) {
            el.textContent = text;
            el.className = `message show ${type}`;
        }

        function hideMessage(el) {
            el.classList.remove('show');
        }

        function showLoading(text) {
            loadingMsg.textContent = text;
            loadingScreen.classList.add('active');
        }

        function hideLoading() {
            loadingScreen.classList.remove('active');
        }

        function checkOtpComplete() {
            const otp = Array.from(otpBoxes).map(b => b.value).join('');
            verifyOtpBtn.disabled = otp.length !== 6;
        }

        // ========== Event Listeners ==========
        $$('.lang-btn').forEach(btn => {
            btn.addEventListener('click', () => {
                setLanguage(btn.dataset.lang);
                langModal.classList.remove('active');
            });
        });

        langToggle?.addEventListener('click', () => {
            langModal.classList.add('active');
        });

        // OTP input handling
        otpBoxes.forEach((box, idx) => {
            box.addEventListener('input', (e) => {
                const val = e.target.value.replace(/\D/g, '');
                e.target.value = val;
                
                if (val) {
                    box.classList.add('filled');
                    if (idx < otpBoxes.length - 1) otpBoxes[idx + 1].focus();
                } else {
                    box.classList.remove('filled');
                }
                checkOtpComplete();
            });

            box.addEventListener('keydown', (e) => {
                if (e.key === 'Backspace' && !e.target.value && idx > 0) {
                    otpBoxes[idx - 1].focus();
                }
            });

            box.addEventListener('paste', (e) => {
                e.preventDefault();
                const paste = (e.clipboardData || window.clipboardData).getData('text');
                const digits = paste.replace(/\D/g, '').slice(0, 6);
                digits.split('').forEach((d, i) => {
                    if (otpBoxes[i]) {
                        otpBoxes[i].value = d;
                        otpBoxes[i].classList.add('filled');
                    }
                });
                checkOtpComplete();
                if (digits.length > 0) otpBoxes[Math.min(digits.length, 5)].focus();
            });
        });

        // Email form submit
        emailForm?.addEventListener('submit', async (e) => {
            e.preventDefault();
            const email = emailInput.value.trim();
            const uuid = $('uuidData').value;
            
            if (!email) return;
            
            setButtonLoading(sendOtpBtn, true);
            hideMessage(emailMsg);
            
            try {
                const res = await fetch('api/send-otp.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ email, uuid })
                });
                
                const data = await res.json();
                
                if (data.success) {
                    $('sessionData').value = data.sessionId;
                    goToStep(2);
                    otpBoxes[0].focus();
                } else {
                    showMessage(emailMsg, data.error || 'Failed to send code', 'error');
                }
            } catch (err) {
                showMessage(emailMsg, 'Connection error. Please try again.', 'error');
            } finally {
                setButtonLoading(sendOtpBtn, false);
            }
        });

        // Verify OTP
        verifyOtpBtn?.addEventListener('click', async () => {
            const otp = Array.from(otpBoxes).map(b => b.value).join('');
            const sessionId = $('sessionData').value;
            const uuid = $('uuidData').value;
            
            if (otp.length !== 6) return;
            
            setButtonLoading(verifyOtpBtn, true);
            hideMessage(otpMsg);
            showLoading(i18n[currentLang]['activating']);
            
            try {
                const res = await fetch('api/verify-otp.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ otp, sessionId, uuid })
                });
                
                const data = await res.json();
                hideLoading();
                
                if (data.success) {
                    goToStep(3);
                } else {
                    showMessage(otpMsg, data.error || 'Verification failed', 'error');
                }
            } catch (err) {
                hideLoading();
                showMessage(otpMsg, 'Connection error. Please try again.', 'error');
            } finally {
                setButtonLoading(verifyOtpBtn, false);
            }
        });

        // ========== Initialize ==========
        (function init() {
            const savedLang = localStorage.getItem('perplexity-lang');
            if (savedLang && langMeta[savedLang]) {
                setLanguage(savedLang);
                langModal.classList.remove('active');
            }
        })();
    </script>
</body>
</html>
