<?php
/**
 * Perplexity Pro Automated Redemption System - Configuration
 *
 * IMPORTANT: Update these values before deployment
 */

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'kardqpdk_kardonia_perplexity');
define('DB_USER', 'kardqpdk_ziwar');
define('DB_PASS', 'Kurdistan@1900');

// Node.js Service Configuration
define('NODE_SERVICE_URL', 'https://conceptive-noncomprehensiblely-bertha.ngrok-free.dev');
define('NODE_SECRET', '93Yyg8tWsjN5OhiMDwbKq4QVdfmkIuG0TnaLXPrvc26xpUZEzFRoC7JlBeSHA1');

// Security Settings
define('MAX_OTP_ATTEMPTS', 3);
define('SESSION_TIMEOUT_MINUTES', 30);

// Enable error reporting (disable in production)
if ($_SERVER['SERVER_NAME'] === 'localhost' || $_SERVER['SERVER_NAME'] === '127.0.0.1') {
    ini_set('display_errors', 1);
    error_reporting(E_ALL);
} else {
    ini_set('display_errors', 0);
    error_reporting(0);
}

// Database Connection
try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
} catch (PDOException $e) {
    // Don't expose database errors to users
    http_response_code(500);
    die('Database connection failed. Please contact administrator.');
}

/**
 * Helper function to call Node.js automation service
 *
 * @param string $endpoint API endpoint (e.g., '/send-otp')
 * @param array $data POST data to send
 * @return array Response from Node.js service
 */
function callNodeService($endpoint, $data) {
    // Ensure secret is in the data payload
    if (!isset($data['secret'])) {
        $data['secret'] = NODE_SECRET;
    }
    
    $ch = curl_init(NODE_SERVICE_URL . $endpoint);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json'
        ],
        CURLOPT_TIMEOUT => 60,
        CURLOPT_CONNECTTIMEOUT => 10
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);

    // Log errors for debugging
    if ($httpCode !== 200) {
        error_log("Node.js service error: HTTP $httpCode - $error");
        return ['success' => false, 'error' => 'Automation service unavailable'];
    }

    if (!$response) {
        error_log("Node.js service error: Empty response");
        return ['success' => false, 'error' => 'Invalid service response'];
    }

    $decoded = json_decode($response, true);
    if ($decoded === null) {
        error_log("Node.js service error: Invalid JSON response");
        return ['success' => false, 'error' => 'Invalid service response'];
    }

    return $decoded;
}

/**
 * Helper function to validate UUID format
 *
 * @param string $uuid UUID to validate
 * @return bool True if valid UUID format
 */
function isValidUUID($uuid) {
    return preg_match('/^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$/i', $uuid) === 1;
}

/**
 * Helper function to sanitize and validate email
 *
 * @param string $email Email address to validate
 * @return string|false Sanitized email or false if invalid
 */
function validateEmail($email) {
    $email = filter_var($email, FILTER_SANITIZE_EMAIL);
    return filter_var($email, FILTER_VALIDATE_EMAIL);
}

/**
 * Helper function to send JSON response
 *
 * @param array $data Data to send
 * @param int $statusCode HTTP status code
 */
function sendJSON($data, $statusCode = 200) {
    http_response_code($statusCode);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data);
    exit;
}
?>