/**
 * Translations for 4 languages: English, Chinese, Arabic, Kurdish Sorani
 */

const translations = {
    en: {
        // Modal
        'select-language': 'Select Language',

        // Header
        'title': 'Perplexity Pro Activation',
        'subtitle': '12 months subscription',
        'warning': '*Valid only for accounts without Pro',

        // Step 1: Email
        'enter-email': 'Enter your email',
        'email-desc': 'Enter the email you want to activate Perplexity Pro on',
        'email-placeholder': 'your@email.com',
        'send-code': 'Send Code',

        // Step 2: OTP
        'enter-otp': 'Enter 6-digit code',
        'otp-desc': 'Check your email for the verification code',
        'verify': 'Verify',

        // Step 3: Success
        'success': 'Activated Successfully!',
        'success-desc': 'Your Perplexity Pro subscription has been activated',
        'go-perplexity': 'Go to Perplexity',

        // Errors
        'invalid-link': 'Invalid Link',
        'invalid-link-desc': 'This redemption link is invalid or malformed.',
        'invalid-email': 'Please enter a valid email address',
        'already-used': 'This code has already been used',
        'too-many-attempts': 'Too many attempts. Please wait 5 minutes.',
        'send-failed': 'Failed to send code. Please try again.',
        'invalid-otp': 'Invalid code. Please check your email and try again.',
        'already-subscribed': 'This account already has a Pro subscription',
        'promo-invalid': 'Promo code could not be applied',
        'session-expired': 'Session expired. Please start again.',
        'verification-failed': 'Verification failed. Please try again.',
        'error-occurred': 'An error occurred. Please try again.',

        // Messages
        'code-sent': 'Code sent! Check your email.',
        'verifying': 'Verifying...',
        'sending': 'Sending...'
    },

    zh: {
        // Modal
        'select-language': '选择语言',

        // Header
        'title': 'Perplexity Pro 激活',
        'subtitle': '12个月订阅',
        'warning': '*仅适用于没有Pro的账户',

        // Step 1: Email
        'enter-email': '输入您的邮箱',
        'email-desc': '输入您要激活 Perplexity Pro 的邮箱地址',
        'email-placeholder': '您的邮箱@example.com',
        'send-code': '发送验证码',

        // Step 2: OTP
        'enter-otp': '输入6位验证码',
        'otp-desc': '请查看您的邮箱获取验证码',
        'verify': '验证',

        // Step 3: Success
        'success': '激活成功！',
        'success-desc': '您的 Perplexity Pro 订阅已激活',
        'go-perplexity': '前往 Perplexity',

        // Errors
        'invalid-link': '无效链接',
        'invalid-link-desc': '此兑换链接无效或格式错误。',
        'invalid-email': '请输入有效的邮箱地址',
        'already-used': '此代码已被使用',
        'too-many-attempts': '尝试次数过多。请等待5分钟。',
        'send-failed': '发送失败，请重试。',
        'invalid-otp': '验证码无效。请检查您的邮箱后重试。',
        'already-subscribed': '此账户已有Pro订阅',
        'promo-invalid': '促销代码无法应用',
        'session-expired': '会话已过期。请重新开始。',
        'verification-failed': '验证失败。请重试。',
        'error-occurred': '发生错误。请重试。',

        // Messages
        'code-sent': '验证码已发送！请查看您的邮箱。',
        'verifying': '验证中...',
        'sending': '发送中...'
    },

    ar: {
        // Modal
        'select-language': 'اختر اللغة',

        // Header
        'title': 'تفعيل Perplexity Pro',
        'subtitle': 'اشتراك 12 شهر',
        'warning': '*صالح فقط للحسابات بدون Pro',

        // Step 1: Email
        'enter-email': 'أدخل بريدك الإلكتروني',
        'email-desc': 'أدخل البريد الإلكتروني الذي تريد تفعيل Perplexity Pro عليه',
        'email-placeholder': 'بريدك@example.com',
        'send-code': 'إرسال الرمز',

        // Step 2: OTP
        'enter-otp': 'أدخل الرمز المكون من 6 أرقام',
        'otp-desc': 'تحقق من بريدك الإلكتروني للحصول على رمز التحقق',
        'verify': 'تحقق',

        // Step 3: Success
        'success': 'تم التفعيل بنجاح!',
        'success-desc': 'تم تفعيل اشتراكك في Perplexity Pro',
        'go-perplexity': 'اذهب إلى Perplexity',

        // Errors
        'invalid-link': 'رابط غير صالح',
        'invalid-link-desc': 'رابط الاسترداد هذا غير صالح أو خاطئ.',
        'invalid-email': 'يرجى إدخال عنوان بريد إلكتروني صالح',
        'already-used': 'تم استخدام هذا الرمز بالفعل',
        'too-many-attempts': 'محاولات كثيرة جداً. يرجى الانتظار 5 دقائق.',
        'send-failed': 'فشل الإرسال. يرجى المحاولة مرة أخرى.',
        'invalid-otp': 'رمز غير صالح. يرجى التحقق من بريدك الإلكتروني والمحاولة مرة أخرى.',
        'already-subscribed': 'هذا الحساب لديه بالفعل اشتراك Pro',
        'promo-invalid': 'تعذر تطبيق رمز الترويج',
        'session-expired': 'انتهت الجلسة. يرجى البدء من جديد.',
        'verification-failed': 'فشل التحقق. يرجى المحاولة مرة أخرى.',
        'error-occurred': 'حدث خطأ. يرجى المحاولة مرة أخرى.',

        // Messages
        'code-sent': 'تم إرسال الرمز! تحقق من بريدك الإلكتروني.',
        'verifying': 'جاري التحقق...',
        'sending': 'جاري الإرسال...'
    },

    ku: {
        // Modal
        'select-language': 'زمان هەڵبژێرە',

        // Header
        'title': 'چالاککردنی Perplexity Pro',
        'subtitle': 'بەشداری 12 مانگ',
        'warning': '*تەنها بۆ ئەکاونتەکانی بەبێ Pro',

        // Step 1: Email
        'enter-email': 'ئیمەیڵەکەت بنووسە',
        'email-desc': 'ئەو ئیمەیڵە بنووسە کە دەتەوێت Perplexity Pro چالاکبکەیتی',
        'email-placeholder': 'ئیمەیڵەکەت@example.com',
        'send-code': 'کۆد بنێرە',

        // Step 2: OTP
        'enter-otp': 'کۆدی 6 ژمارەیی بنووسە',
        'otp-desc': 'ئیمەیڵەکەت بپشکنە بۆ کۆدی پشتڕاستکردنەوە',
        'verify': 'پشتڕاستکردنەوە',

        // Step 3: Success
        'success': 'بە سەرکەوتوویی چالاککرا!',
        'success-desc': 'بەشداریی Perplexity Pro ت چالاککرا',
        'go-perplexity': 'بڕۆ بۆ Perplexity',

        // Errors
        'invalid-link': 'بەستەری نادروست',
        'invalid-link-desc': 'ئەم بەستەرە نادروستە یان هەڵەیە.',
        'invalid-email': 'تکایە ناونیشانی ئیمەیڵێکی دروست بنووسە',
        'already-used': 'ئەم کۆدە پێشتر بەکارهاتووە',
        'too-many-attempts': 'هەوڵی زۆر. تکایە 5 خولەک چاوەڕێبکە.',
        'send-failed': 'ناردن سەرکەوتوو نەبوو. تکایە دووبارە هەوڵبدەرەوە.',
        'invalid-otp': 'کۆدی نادروست. تکایە ئیمەیڵەکەت بپشکنە و دووبارە هەوڵبدەرەوە.',
        'already-subscribed': 'ئەم ئەکاونتە پێشتر بەشداری Pro هەیە',
        'promo-invalid': 'کۆدی پرۆمۆ جێبەجێ نەکرا',
        'session-expired': 'دانیشتن بەسەرچوو. تکایە دووبارە دەستپێبکەرەوە.',
        'verification-failed': 'پشتڕاستکردنەوە سەرکەوتوو نەبوو. تکایە دووبارە هەوڵبدەرەوە.',
        'error-occurred': 'هەڵەیەک ڕوویدا. تکایە دووبارە هەوڵبدەرەوە.',

        // Messages
        'code-sent': 'کۆد نێردرا! ئیمەیڵەکەت بپشکنە.',
        'verifying': 'پشتڕاستدەکرێتەوە...',
        'sending': 'دەنێردرێت...'
    }
};

// Export for use in main.js
window.translations = translations;
