<?php
/**
 * Perplexity Pro Admin Panel - Premium Design v2
 * For Iraq & China partners
 */

session_start();

define('ADMIN_PASSWORD', 'Kurdistan@1900Admin');

// Check if logged in
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
        if ($_POST['password'] === ADMIN_PASSWORD) {
            $_SESSION['admin_logged_in'] = true;
            header('Location: index.php');
            exit;
        } else {
            $error = 'Invalid password';
        }
    }
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Admin Login - Perplexity Pro</title>
        <link rel="icon" type="image/png" href="../favicon.png">
        <link href="https://fonts.googleapis.com/css2?family=Sora:wght@400;500;600;700&display=swap" rel="stylesheet">
        <style>
            * { margin: 0; padding: 0; box-sizing: border-box; }
            body {
                font-family: 'Sora', sans-serif;
                background: #0d1117;
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 20px;
            }
            .login-box {
                background: rgba(22, 27, 34, 0.9);
                border: 1px solid rgba(32, 178, 170, 0.2);
                padding: 40px;
                border-radius: 20px;
                width: 100%;
                max-width: 400px;
                text-align: center;
            }
            .logo { width: 60px; margin-bottom: 20px; }
            h1 { color: #20b2aa; font-size: 24px; margin-bottom: 8px; }
            .subtitle { color: rgba(255,255,255,0.5); font-size: 14px; margin-bottom: 30px; }
            input {
                width: 100%;
                padding: 14px 18px;
                background: rgba(13, 17, 23, 0.8);
                border: 1px solid rgba(255,255,255,0.1);
                border-radius: 10px;
                color: #fff;
                font-size: 16px;
                margin-bottom: 20px;
                font-family: inherit;
            }
            input:focus { outline: none; border-color: #20b2aa; }
            button {
                width: 100%;
                padding: 14px;
                background: linear-gradient(135deg, #20b2aa, #06b6d4);
                border: none;
                border-radius: 10px;
                color: #0d1117;
                font-size: 16px;
                font-weight: 600;
                cursor: pointer;
                font-family: inherit;
            }
            button:hover { opacity: 0.9; }
            .error {
                background: rgba(248, 81, 73, 0.15);
                color: #f85149;
                padding: 12px;
                border-radius: 10px;
                margin-bottom: 20px;
                font-size: 14px;
            }
        </style>
    </head>
    <body>
        <div class="login-box">
            <img src="../assets/images/logo.png" alt="Perplexity" class="logo">
            <h1>Admin Panel</h1>
            <p class="subtitle">Perplexity Pro Code Manager</p>
            <?php if (isset($error)): ?>
                <div class="error"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            <form method="POST">
                <input type="password" name="password" placeholder="Enter password" required autofocus>
                <button type="submit">Login</button>
            </form>
        </div>
    </body>
    </html>
    <?php
    exit;
}

require_once '../config.php';

// Check/create columns
try {
    $result = $pdo->query("SHOW COLUMNS FROM codes LIKE 'region'");
    if ($result->rowCount() == 0) {
        $pdo->exec("ALTER TABLE codes ADD COLUMN region VARCHAR(10) DEFAULT NULL");
    }
    $result = $pdo->query("SHOW COLUMNS FROM codes LIKE 'price_yuan'");
    if ($result->rowCount() == 0) {
        $pdo->exec("ALTER TABLE codes ADD COLUMN price_yuan DECIMAL(10,2) DEFAULT NULL");
    }
} catch (PDOException $e) {}

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    switch ($_POST['action']) {
        case 'add_code':
            $code = strtoupper(trim($_POST['code']));
            $uuid = !empty($_POST['uuid']) ? $_POST['uuid'] : generateUUID();
            $region = !empty($_POST['region']) ? $_POST['region'] : null;
            $price = !empty($_POST['price_yuan']) ? floatval($_POST['price_yuan']) : null;
            
            try {
                $stmt = $pdo->prepare("INSERT INTO codes (code, uuid, status, region, price_yuan, created_at) VALUES (?, ?, 'available', ?, ?, NOW())");
                $stmt->execute([$code, $uuid, $region, $price]);
                $message = "Code added!";
            } catch (PDOException $e) {
                $error = "Error: " . $e->getMessage();
            }
            break;
            
        case 'bulk_add':
            $lines = explode("\n", trim($_POST['bulk_codes']));
            $region = !empty($_POST['bulk_region']) ? $_POST['bulk_region'] : null;
            $price = !empty($_POST['bulk_price']) ? floatval($_POST['bulk_price']) : null;
            $added = 0;
            
            foreach ($lines as $line) {
                $code = strtoupper(trim($line));
                if (empty($code)) continue;
                try {
                    $stmt = $pdo->prepare("INSERT INTO codes (code, uuid, status, region, price_yuan, created_at) VALUES (?, ?, 'available', ?, ?, NOW())");
                    $stmt->execute([$code, generateUUID(), $region, $price]);
                    $added++;
                } catch (PDOException $e) {}
            }
            $message = "Added $added codes!";
            break;
        
        case 'update':
            $uuid = $_POST['uuid'];
            $region = !empty($_POST['region']) ? $_POST['region'] : null;
            $price = !empty($_POST['price']) ? floatval($_POST['price']) : null;
            $pdo->prepare("UPDATE codes SET region = ?, price_yuan = ? WHERE uuid = ?")->execute([$region, $price, $uuid]);
            $message = "Updated!";
            break;
            
        case 'delete':
            $pdo->prepare("DELETE FROM codes WHERE uuid = ?")->execute([$_POST['uuid']]);
            $message = "Deleted!";
            break;
            
        case 'logout':
            session_destroy();
            header('Location: index.php');
            exit;
    }
}

$filter = $_GET['filter'] ?? 'all';
$sql = "SELECT * FROM codes";
if ($filter === 'iraq') $sql .= " WHERE region = 'iraq'";
elseif ($filter === 'china') $sql .= " WHERE region = 'china'";
elseif ($filter === 'unset') $sql .= " WHERE region IS NULL";
$sql .= " ORDER BY created_at DESC";
$codes = $pdo->query($sql)->fetchAll();

$stats = $pdo->query("SELECT 
    COUNT(*) as total,
    SUM(status = 'available') as available,
    SUM(status = 'used') as used,
    SUM(region = 'iraq') as iraq,
    SUM(region = 'iraq' AND status = 'available') as iraq_avail,
    SUM(region = 'china') as china,
    SUM(region = 'china' AND status = 'available') as china_avail,
    SUM(region IS NULL) as unset
FROM codes")->fetch();

function generateUUID() {
    return sprintf('%08x-%04x-%04x-%04x-%012x',
        mt_rand(0, 0xffffffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff),
        mt_rand(0, 0xffff), mt_rand(0, 0xffffffffffff));
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Perplexity Pro</title>
    <link rel="icon" type="image/png" href="../favicon.png">
    <link href="https://fonts.googleapis.com/css2?family=Sora:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        :root {
            --bg: #0d1117;
            --card: #161b22;
            --border: #30363d;
            --accent: #20b2aa;
            --accent2: #06b6d4;
            --text: #f0f6fc;
            --muted: rgba(240,246,252,0.5);
            --red: #f85149;
            --yellow: #f0b429;
            --green: #3fb950;
        }
        
        body {
            font-family: 'Sora', sans-serif;
            background: var(--bg);
            color: var(--text);
            min-height: 100vh;
            padding: 16px;
        }
        
        .container { max-width: 1400px; margin: 0 auto; }
        
        /* Header */
        .header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 20px 24px;
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 16px;
            margin-bottom: 20px;
            flex-wrap: wrap;
            gap: 16px;
        }
        .header-left {
            display: flex;
            align-items: center;
            gap: 16px;
        }
        .header img { height: 40px; }
        .header h1 {
            font-size: 20px;
            background: linear-gradient(135deg, var(--accent), var(--accent2));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        .header p { color: var(--muted); font-size: 13px; }
        .logout-btn {
            background: rgba(248,81,73,0.15);
            color: var(--red);
            border: 1px solid rgba(248,81,73,0.3);
            padding: 10px 20px;
            border-radius: 10px;
            cursor: pointer;
            font-family: inherit;
            font-size: 14px;
        }
        
        /* Stats */
        .stats {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 12px;
            margin-bottom: 20px;
        }
        .stat {
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 12px;
            padding: 16px;
        }
        .stat-label { font-size: 11px; color: var(--muted); text-transform: uppercase; letter-spacing: 1px; margin-bottom: 6px; }
        .stat-value { font-size: 28px; font-weight: 700; }
        .stat-sub { font-size: 12px; color: var(--muted); margin-top: 4px; }
        .stat.iraq { border-left: 3px solid var(--red); }
        .stat.china { border-left: 3px solid var(--yellow); }
        .stat.total { border-left: 3px solid var(--accent); }
        .stat.unset { border-left: 3px solid var(--muted); }
        
        /* Messages */
        .msg {
            padding: 12px 16px;
            border-radius: 10px;
            margin-bottom: 16px;
            font-size: 14px;
        }
        .msg.success { background: rgba(63,185,80,0.15); color: var(--green); }
        .msg.error { background: rgba(248,81,73,0.15); color: var(--red); }
        
        /* Form Card */
        .form-card {
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 16px;
            padding: 24px;
            margin-bottom: 20px;
        }
        .tabs {
            display: flex;
            gap: 8px;
            margin-bottom: 20px;
        }
        .tab {
            padding: 10px 20px;
            background: transparent;
            border: none;
            color: var(--muted);
            font-family: inherit;
            font-size: 14px;
            cursor: pointer;
            border-radius: 8px;
        }
        .tab.active { background: rgba(32,178,170,0.15); color: var(--accent); }
        .tab-content { display: none; }
        .tab-content.active { display: block; }
        
        .form-grid {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr auto;
            gap: 12px;
            align-items: end;
        }
        .form-group label {
            display: block;
            font-size: 12px;
            color: var(--muted);
            margin-bottom: 6px;
        }
        input[type="text"], input[type="number"], textarea, select {
            width: 100%;
            padding: 12px;
            background: var(--bg);
            border: 1px solid var(--border);
            border-radius: 8px;
            color: var(--text);
            font-family: inherit;
            font-size: 14px;
        }
        input:focus, textarea:focus, select:focus { outline: none; border-color: var(--accent); }
        textarea { min-height: 100px; resize: vertical; }
        
        /* Region Selector */
        .region-select {
            display: flex;
            gap: 0;
            border-radius: 8px;
            overflow: hidden;
            border: 1px solid var(--border);
        }
        .region-select input { display: none; }
        .region-select label {
            flex: 1;
            padding: 12px 16px;
            background: var(--bg);
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            font-size: 13px;
            transition: all 0.2s;
            margin: 0;
        }
        .region-select label:not(:last-child) { border-right: 1px solid var(--border); }
        .region-select label img { width: 20px; height: 14px; object-fit: cover; border-radius: 2px; }
        .region-select input:checked + label { background: rgba(32,178,170,0.2); color: var(--accent); }
        .region-select input[value="iraq"]:checked + label { background: rgba(248,81,73,0.2); color: var(--red); }
        .region-select input[value="china"]:checked + label { background: rgba(240,180,41,0.2); color: var(--yellow); }
        
        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            font-family: inherit;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            white-space: nowrap;
        }
        .btn-primary { background: linear-gradient(135deg, var(--accent), var(--accent2)); color: var(--bg); }
        .btn-danger { background: rgba(248,81,73,0.2); color: var(--red); }
        .btn-sm { padding: 8px 12px; font-size: 12px; }
        
        /* Filter */
        .filters {
            display: flex;
            gap: 8px;
            margin-bottom: 16px;
            flex-wrap: wrap;
        }
        .filter-btn {
            padding: 8px 16px;
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 8px;
            color: var(--muted);
            font-family: inherit;
            font-size: 13px;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 6px;
        }
        .filter-btn img { width: 16px; height: 11px; object-fit: cover; border-radius: 2px; }
        .filter-btn.active { border-color: var(--accent); color: var(--accent); background: rgba(32,178,170,0.1); }
        .filter-btn.active.iraq { border-color: var(--red); color: var(--red); background: rgba(248,81,73,0.1); }
        .filter-btn.active.china { border-color: var(--yellow); color: var(--yellow); background: rgba(240,180,41,0.1); }
        
        /* Table */
        .table-wrap {
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 16px;
            overflow: hidden;
        }
        table { width: 100%; border-collapse: collapse; }
        th {
            text-align: left;
            padding: 14px 16px;
            font-size: 11px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: var(--muted);
            background: rgba(0,0,0,0.2);
        }
        td {
            padding: 12px 16px;
            border-top: 1px solid var(--border);
            font-size: 13px;
        }
        tr:hover { background: rgba(255,255,255,0.02); }
        
        .badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 6px;
            font-size: 11px;
            font-weight: 600;
        }
        .badge.available { background: rgba(63,185,80,0.15); color: var(--green); }
        .badge.used { background: rgba(248,81,73,0.15); color: var(--red); }
        
        .region-tag {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 4px 10px;
            border-radius: 6px;
            font-size: 12px;
        }
        .region-tag img { width: 16px; height: 11px; object-fit: cover; border-radius: 2px; }
        .region-tag.iraq { background: rgba(248,81,73,0.15); color: var(--red); }
        .region-tag.china { background: rgba(240,180,41,0.15); color: var(--yellow); }
        .region-tag.none { color: var(--muted); }
        
        .price { color: var(--yellow); font-family: monospace; }
        .link-copy {
            background: var(--bg);
            padding: 6px 10px;
            border-radius: 6px;
            font-family: monospace;
            font-size: 11px;
            cursor: pointer;
            border: 1px solid var(--border);
        }
        .link-copy:hover { border-color: var(--accent); color: var(--accent); }
        
        .actions {
            display: flex;
            gap: 6px;
            align-items: center;
            flex-wrap: wrap;
        }
        .actions select, .actions input {
            padding: 6px 8px;
            font-size: 12px;
            width: auto;
        }
        .actions input[type="number"] { width: 70px; }
        
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: var(--muted);
        }
        
        .toast {
            position: fixed;
            bottom: 20px;
            right: 20px;
            background: var(--green);
            color: var(--bg);
            padding: 12px 20px;
            border-radius: 10px;
            font-weight: 600;
            display: none;
            z-index: 1000;
        }
        
        /* Mobile */
        @media (max-width: 900px) {
            .stats { grid-template-columns: repeat(2, 1fr); }
            .form-grid { grid-template-columns: 1fr; }
            .header { flex-direction: column; align-items: flex-start; }
            th, td { padding: 10px 12px; }
            .actions { flex-direction: column; align-items: flex-start; }
        }
        
        @media (max-width: 600px) {
            body { padding: 10px; }
            .stats { grid-template-columns: 1fr 1fr; gap: 8px; }
            .stat { padding: 12px; }
            .stat-value { font-size: 22px; }
            .form-card { padding: 16px; }
            
            /* Mobile table */
            .table-wrap { border-radius: 12px; }
            table, thead, tbody, th, td, tr { display: block; }
            thead { display: none; }
            tr {
                border-bottom: 1px solid var(--border);
                padding: 12px;
                margin-bottom: 8px;
            }
            td {
                border: none;
                padding: 6px 0;
                display: flex;
                justify-content: space-between;
                align-items: center;
            }
            td::before {
                content: attr(data-label);
                font-size: 11px;
                color: var(--muted);
                text-transform: uppercase;
            }
            .actions { width: 100%; margin-top: 10px; }
        }
    </style>
</head>
<body>
    <div class="toast" id="toast">✓ Copied!</div>
    
    <div class="container">
        <header class="header">
            <div class="header-left">
                <img src="../assets/images/logo.png" alt="Perplexity">
                <div>
                    <h1>Perplexity Pro Admin</h1>
                    <p>Iraq & China Partner Management</p>
                </div>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="logout">
                <button type="submit" class="logout-btn">Logout</button>
            </form>
        </header>
        
        <?php if ($message): ?>
            <div class="msg success"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>
        <?php if ($error): ?>
            <div class="msg error"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        
        <div class="stats">
            <div class="stat total">
                <div class="stat-label">Total Codes</div>
                <div class="stat-value"><?= $stats['total'] ?? 0 ?></div>
                <div class="stat-sub"><?= $stats['available'] ?? 0 ?> available</div>
            </div>
            <div class="stat iraq">
                <div class="stat-label">🇮🇶 Iraq</div>
                <div class="stat-value"><?= $stats['iraq'] ?? 0 ?></div>
                <div class="stat-sub"><?= $stats['iraq_avail'] ?? 0 ?> available</div>
            </div>
            <div class="stat china">
                <div class="stat-label">🇨🇳 China</div>
                <div class="stat-value"><?= $stats['china'] ?? 0 ?></div>
                <div class="stat-sub"><?= $stats['china_avail'] ?? 0 ?> available</div>
            </div>
            <div class="stat unset">
                <div class="stat-label">Unassigned</div>
                <div class="stat-value"><?= $stats['unset'] ?? 0 ?></div>
                <div class="stat-sub">No region set</div>
            </div>
        </div>
        
        <div class="form-card">
            <div class="tabs">
                <button class="tab active" onclick="switchTab('single', this)">+ Add Code</button>
                <button class="tab" onclick="switchTab('bulk', this)">Bulk Import</button>
            </div>
            
            <div id="single" class="tab-content active">
                <form method="POST">
                    <input type="hidden" name="action" value="add_code">
                    <div class="form-grid">
                        <div class="form-group">
                            <label>Promo Code *</label>
                            <input type="text" name="code" required placeholder="CODE123" style="text-transform:uppercase">
                        </div>
                        <div class="form-group">
                            <label>Region</label>
                            <div class="region-select">
                                <input type="radio" name="region" value="iraq" id="r_iraq">
                                <label for="r_iraq"><img src="../assets/images/flag-ar.png"> Iraq</label>
                                <input type="radio" name="region" value="china" id="r_china">
                                <label for="r_china"><img src="../assets/images/flag-zh.png"> China</label>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>Price (¥)</label>
                            <input type="number" name="price_yuan" step="0.01" placeholder="0.00">
                        </div>
                        <button type="submit" class="btn btn-primary">Add</button>
                    </div>
                </form>
            </div>
            
            <div id="bulk" class="tab-content">
                <form method="POST">
                    <input type="hidden" name="action" value="bulk_add">
                    <div class="form-grid" style="grid-template-columns: 1fr 1fr auto;">
                        <div class="form-group">
                            <label>Region for All</label>
                            <div class="region-select">
                                <input type="radio" name="bulk_region" value="iraq" id="br_iraq">
                                <label for="br_iraq"><img src="../assets/images/flag-ar.png"> Iraq</label>
                                <input type="radio" name="bulk_region" value="china" id="br_china">
                                <label for="br_china"><img src="../assets/images/flag-zh.png"> China</label>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>Price (¥)</label>
                            <input type="number" name="bulk_price" step="0.01" placeholder="0.00">
                        </div>
                        <button type="submit" class="btn btn-primary">Import</button>
                    </div>
                    <div class="form-group" style="margin-top:16px">
                        <label>Codes (one per line)</label>
                        <textarea name="bulk_codes" placeholder="CODE1&#10;CODE2&#10;CODE3"></textarea>
                    </div>
                </form>
            </div>
        </div>
        
        <div class="filters">
            <a href="?filter=all" class="filter-btn <?= $filter === 'all' ? 'active' : '' ?>">All (<?= $stats['total'] ?? 0 ?>)</a>
            <a href="?filter=iraq" class="filter-btn iraq <?= $filter === 'iraq' ? 'active' : '' ?>">
                <img src="../assets/images/flag-ar.png"> Iraq (<?= $stats['iraq'] ?? 0 ?>)
            </a>
            <a href="?filter=china" class="filter-btn china <?= $filter === 'china' ? 'active' : '' ?>">
                <img src="../assets/images/flag-zh.png"> China (<?= $stats['china'] ?? 0 ?>)
            </a>
            <a href="?filter=unset" class="filter-btn <?= $filter === 'unset' ? 'active' : '' ?>">Unassigned (<?= $stats['unset'] ?? 0 ?>)</a>
        </div>
        
        <div class="table-wrap">
            <table>
                <thead>
                    <tr>
                        <th>Code</th>
                        <th>Region</th>
                        <th>Price</th>
                        <th>Status</th>
                        <th>Link</th>
                        <th>Used By</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($codes)): ?>
                        <tr><td colspan="7" class="empty-state">No codes found</td></tr>
                    <?php else: ?>
                        <?php foreach ($codes as $c): ?>
                            <tr>
                                <td data-label="Code"><strong><?= htmlspecialchars($c['code']) ?></strong></td>
                                <td data-label="Region">
                                    <?php if ($c['region'] === 'iraq'): ?>
                                        <span class="region-tag iraq"><img src="../assets/images/flag-ar.png"> Iraq</span>
                                    <?php elseif ($c['region'] === 'china'): ?>
                                        <span class="region-tag china"><img src="../assets/images/flag-zh.png"> China</span>
                                    <?php else: ?>
                                        <span class="region-tag none">—</span>
                                    <?php endif; ?>
                                </td>
                                <td data-label="Price">
                                    <?= $c['price_yuan'] ? '<span class="price">¥' . number_format($c['price_yuan'], 2) . '</span>' : '—' ?>
                                </td>
                                <td data-label="Status">
                                    <span class="badge <?= $c['status'] ?>"><?= ucfirst($c['status']) ?></span>
                                </td>
                                <td data-label="Link">
                                    <span class="link-copy" onclick="copyLink('<?= $c['uuid'] ?>')">...<?= substr($c['uuid'], -8) ?></span>
                                </td>
                                <td data-label="Used By">
                                    <?= $c['used_by'] ? htmlspecialchars($c['used_by']) : '—' ?>
                                </td>
                                <td data-label="Actions">
                                    <?php if ($c['status'] === 'available'): ?>
                                        <div class="actions">
                                            <form method="POST" style="display:flex;gap:6px;align-items:center;flex-wrap:wrap;">
                                                <input type="hidden" name="action" value="update">
                                                <input type="hidden" name="uuid" value="<?= $c['uuid'] ?>">
                                                <select name="region">
                                                    <option value="">—</option>
                                                    <option value="iraq" <?= $c['region'] === 'iraq' ? 'selected' : '' ?>>🇮🇶</option>
                                                    <option value="china" <?= $c['region'] === 'china' ? 'selected' : '' ?>>🇨🇳</option>
                                                </select>
                                                <input type="number" name="price" step="0.01" value="<?= $c['price_yuan'] ?>" placeholder="¥">
                                                <button type="submit" class="btn btn-primary btn-sm">Save</button>
                                            </form>
                                            <form method="POST" onsubmit="return confirm('Delete?')">
                                                <input type="hidden" name="action" value="delete">
                                                <input type="hidden" name="uuid" value="<?= $c['uuid'] ?>">
                                                <button type="submit" class="btn btn-danger btn-sm">✕</button>
                                            </form>
                                        </div>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    
    <script>
        function switchTab(id, btn) {
            document.querySelectorAll('.tab-content').forEach(t => t.classList.remove('active'));
            document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
            document.getElementById(id).classList.add('active');
            btn.classList.add('active');
        }
        
        function copyLink(uuid) {
            navigator.clipboard.writeText('https://kardonia.com/perplexity/?uuid=' + uuid);
            const toast = document.getElementById('toast');
            toast.style.display = 'block';
            setTimeout(() => toast.style.display = 'none', 2000);
        }
    </script>
</body>
</html>
